﻿/*
 * Mathefritz Professor
 * (c) INTERACTIVE Software Solutions GmbH
 *
 * Version: 23.08.2010
 *
 * Stufe 1: Addition und Subtraktion mit 2 einstelligen Zahlen
 * Stufe 2: Addition und Subtraktion mit 1 ein- und 1 zweistelligen Zahl ODER 2 zweistellige Zahlen
 * Stufe 3: Multiplikation mit 2 einstelligen Zahlen
 *          (Division mit 2 einstelligen ODER einer ein- und einer zweistellige Zahlen)
 * Stufe 4: Addition und Subtraktion mit zweistelligen Zahlen
 *          Multiplikation mit ein- und zweistelligen Zahlen
 *          (Division mit einstelligen bis dreistelligen Zahlen)
 */


var missing;
var modus;

var startNewGame = false;
var resultCounter = 0;
var exerciseCounter = 1;
var success = false;
var calculatorMode = false;

var calcNumber1 = '';
var calcNumber2 = '';
var calcNumber1Str = '';
var calcNumber2Str = '';

var calcOperator = '';
var calcResult = 0;
var addComma = false;

var calcModus = 1;

var tmpText = '';

var DEBUG = false;




var level = 0;
var calcOrGameMode = 2; // 1 = Taschenrechner; 2 = Spiel-Modus

var STEP_WIDTH = 102;
var MODUS_WIDTH = 368;
var NUMBER_WIDTH = 190;
var AUFGABE_HEIGHT = 26;
var currentUnknownString = '';


$(function() {
        /*
                Einstellen der Sprache:
                - DEUTSCH: keine Einstellung noetig
                - ENGLISCH: "setLanguage('en');" aufrufen
        */
        // setLanguage('en');

        $.fn.activate = function() {
                $(this).each(function() {
                        var _this = $(this);
                        if (_this.hasClass('inactive')) {
                                hover(_this, 2 * NUMBER_WIDTH, false);
                                _this.removeClass('inactive');
                        }
                        /*
                        else if (_this.hasClass('isHover')) {
                                hover(_this, NUMBER_WIDTH, false);
                                _this.removeClass('isHover');
                        }
                        */
                });
        }

        $.fn.deactivate = function() {
                $(this).each(function() {
                        var _this = $(this);
                        if (!_this.hasClass('inactive')) {
                                var _width = (_this.hasClass('isHover')) ? NUMBER_WIDTH : 2 * NUMBER_WIDTH;
                                hover(_this, _width, true);
                                _this.addClass('inactive');
                                _this.removeClass('isHover');
                        }
                });
        }


        // Spiel-Stufen 1-4
        $('.stufe').hover(function() {
                var _this = $(this);
                if (!_this.hasClass('inactive') && _this.attr('id').split('_')[1] != level) {
                        hover(_this, STEP_WIDTH, true);
                        _this.addClass('isHover');
                }
        }, function() {
                var _this = $(this);
                if (!_this.hasClass('inactive') && _this.attr('id').split('_')[1] != level) {
                        hover(_this, STEP_WIDTH, false);
                        _this.removeClass('isHover');
                }
        });
        $('.stufe').click(function() {
                var _this = $(this);
                if (_this.hasClass('inactive'))
                        return false;

                if (_this.attr('id').split('_')[1] != level) {
                        // vorherige angeklickte Stufe zurueckdrehen
                        if (level != 0) {
                                hover($('#stufe_' + level), STEP_WIDTH, false);
                        }
                        level = _this.attr('id').split('_')[1];
                }

                $('.stufe').addClass('inactive');

                // Spiel starten
                enable(new Array('all'));
                $('#chooseLevel').fadeOut();
                $('#aufgabeNo').fadeIn();
                hideOtherLevel(level);

                $('.inputElement').removeClass('unknown');
                generateTask();

                $('#anzeigeGame').fadeIn();

        });

        // Modus
        $('.modus').hover(function() {
                var _this = $(this);
                if (_this.attr('id').split('_')[1] != calcOrGameMode) {
                        hover(_this, MODUS_WIDTH, true);
                        _this.addClass('isHover');
                }
        }, function() {
                var _this = $(this);
                if (_this.attr('id').split('_')[1] != calcOrGameMode) {
                        hover(_this, MODUS_WIDTH, false);
                        _this.removeClass('isHover');
                }
        });
        $('.modus').click(function() {
                var _this = $(this);
                if (_this.attr('id').split('_')[1] != calcOrGameMode) {
                        hover($('#modus_' + calcOrGameMode), MODUS_WIDTH, false);
                        calcOrGameMode = _this.attr('id').split('_')[1];
                        currentUnknownString = '';

                        if (calcOrGameMode == 1) {
                                // Taschenrechner-Modus
                                resetCalcVars();
                                calculatorMode = true;
                                $('#divStufen').fadeOut();
                                $('#chooseLevel').fadeOut();
                                $('#anzeigeGame').fadeOut();
                                $('#aufgabeNo').fadeOut();
                                $('#continue').fadeOut();

                                $('#anzeigeCalc').text('');
                                $('#anzeigeCalc').fadeIn();
                                $('#lob').hide();

                                $('#punkte').hide();
                        }
                        else if (calcOrGameMode == 2) {
                                // Spiel-Modus
                                newGame();
                        }

                }
        });

        // Ziffernblock
        $('.number').hover(function() {
                var _this = $(this);
                if (!_this.hasClass('inactive')) {
                        hover(_this, NUMBER_WIDTH, true);
                        _this.addClass('isHover');
                }
        }, function() {
                var _this = $(this);
                if (!_this.hasClass('inactive')) {
                        hover(_this, NUMBER_WIDTH, false);
                        _this.removeClass('isHover');
                }
        });




        //styleResult();

        //$('.number').addClass('inactive');
        //$('#back').addClass('inactive');

        disable(new Array('all'));


        // Listener fuer Click-Event: Button "weiter" / "neues Spiel"
        $('#continue').click(function() {
                $('#imgRight').hide();
                $('#imgWrong').hide();
                $('#anzeigeGame2').hide();

                if (startNewGame) {
                        newGame();
                }
                else {
                        generateTask(); // neue Aufgabe generieren
                }

        });

        // Listener fuer Click-Event: Button "back"
        $('#back').click(function() {
                if ($(this).hasClass('inactive')) {
                        return false;
                }

                if (calculatorMode) {
                        // Taschenrechner resetten:
                        $('#anzeigeCalc').text('');
                        //$('#mainInput3').text('');

                        enable(new Array('numbers', 'comma'));
                        disable(new Array('operators', 'equals'));

                        $('.operator').removeClass('active');

                        calcNumber1 = '';
                        calcNumber2 = '';
                        calcNumber1Str = '';
                        calcNumber2Str = '';
                        calcOperator = '';
                        calcResult = 0;
                        addComma = false;
                        calcModus = 1;

                }
                else {
                        // loesche die letzte Ziffern / Rechenzeichen
                        var newUnknown = deleteFirstDigitOrOperator(currentUnknownString);
                        currentUnknownString = newUnknown;
                        $('.unknown').html(getNumber(newUnknown));

                        disable(new Array('equals'));

                        if (enableOperators) {
                                enable(new Array('operators'));
                        }
                        else {
                                enable(new Array('numbers'));
                        }

                        if (!containsInput(newUnknown)) {
                                disable(new Array('back'));
                        }

                }
        });

        // Listener fuer Click-Event: Ziffern und Rechenzeichen
        $('.number').click(function() {
                if ($(this).hasClass('inactive')) {
                        return false;
                }

                //var digitOperatorAttr = $(this).attr('id');
                var digitOperatorAttr = $(this).attr('id').split('btn_')[1]; // vom Benutzer angelickte(s) Ziffer ODER Rechenzeichen
                var digitOperator = parseInt(digitOperatorAttr, 10);
                var isDigit = !isNaN(digitOperator);

                if (!isDigit) {
                        switch (digitOperatorAttr) {
                                // Grundrechenarten:
                                case 'plus': digitOperator = '+'; break;
                                case 'minus': digitOperator = '-'; break;
                                case 'multiplied': digitOperator = '×'; break;
                                case 'divided': digitOperator = '÷'; break;

                                // Sonderzeichen:
                                case 'comma': digitOperator = ','; break;
                                case 'equals': digitOperator = '='; break;

                                default: return false;
                        }
                }

                if (calculatorMode) {
                        var doNotRestyle = false;

                        switch (calcModus) {
                                case 1:
                                        // mehrere Ziffern nacheinander eingeben (1. Zahl)
                                        // solange, bis ein Rechenzeichen angeklickt wurde
                                        if (isDigit) {
                                                if (DEBUG) console.log('case 1, digit, addComma = ' + addComma);
                                                if (addComma) {
                                                        calcNumber1Str = calcNumber1Str + '.' + digitOperator;
                                                        calcNumber1 = parseFloat(calcNumber1Str);
                                                        //$('#mainInput3').text(replacePointComma(calcNumber1Str));

                                                        var tmp = replacePointComma(digitOperator);
                                                        currentUnknownString += tmp;
                                                        $('#anzeigeCalc span:last').append(getNumber(tmp));

                                                        addComma = false;
                                                }
                                                else {

                                                        if (calcNumber1Str == '') {
                                                                // neue Zeile beginnen:
                                                                currentUnknownString = "";
                                                                if (DEBUG) console.log("SPAN 1 ### case 1, leerstring");
                                                                $('#anzeigeCalc').append('<span>');
                                                        }


                                                        calcNumber1Str = calcNumber1Str + '' + digitOperator;
                                                        calcNumber1 = parseFloat(calcNumber1Str);
                                                        //$('#mainInput3').text(replacePointComma(calcNumber1Str));

                                                        var tmp = replacePointComma(digitOperator);
                                                        currentUnknownString += tmp;
                                                        $('#anzeigeCalc span:last').append(getNumber(tmp));

                                                        //styleResult();
                                                }

                                                enable(new Array('operators'));

                                        }
                                        else if (digitOperator == ',') {
                                                if (DEBUG) console.log('case 1, comma');
                                                // pruefen, ob das Komma an der ersten Stelle ist
                                                manageComma(true);

                                                disable(new Array('comma', 'operators', 'equals'));
                                        }
                                        else if (digitOperator == '=') {
                                                if (DEBUG) console.log('case 1, equals');
                                                // hier nicht erlaubt
                                        }
                                        else {
                                                if (DEBUG) console.log('case 1, operator');
                                                calcModus = 2;
                                                calcOperator = digitOperator;
                                                $(this).addClass('active');

                                                //tmpText = $('#anzeigeCalc').html();
                                                tmpText = currentUnknownString;

                                                currentUnknownString += digitOperator;
                                                $('#anzeigeCalc span:last').append(getNumber(digitOperator));
                                                addComma = false;

                                                enable(new Array('comma'));
                                        }

                                        break;

                                case 2:
                                        // Rechenzeichen anklicken, nur das zuletztgeklickt ist aktiv
                                        // solange, bis man eine Ziffer angeklickt hat
                                        if (isDigit) {
                                                if (DEBUG) console.log('case 2, digit');
                                                calcModus = 3;
                                                calcNumber2 = digitOperator; // die erste Ziffer der 2. Zahl
                                                calcNumber2Str = calcNumber2 + '';

                                                //$('#mainInput3').text(calcNumber2Str);

                                                currentUnknownString += calcNumber2Str;
                                                $('#anzeigeCalc span:last').append(getNumber(calcNumber2Str));

                                                // Division durch 0 verhindern:
                                                manageDivisionByZero();

                                                disable(new Array('operators'));

                                        }
                                        else if (digitOperator == ',') {
                                                if (DEBUG) console.log('case 2, comma');
                                                // der User gibt als erste Ziffer der 2. Zahl gleich ein Komma ein

                                                calcModus = 3;

                                                calcNumber2 = '';
                                                calcNumber2Str = '';
                                                manageComma(false);

                                                disable(new Array('comma', 'operators', 'equals'));

                                        }
                                        else if (digitOperator == '=') {
                                                if (DEBUG) console.log('case 2, equals');
                                                // hier nicht erlaubt
                                        }
                                        else {
                                                if (DEBUG) console.log('case 2, operator');
                                                calcOperator = digitOperator;
                                                $('.operator').removeClass('active');
                                                $(this).addClass('active');

                                                var tmp = tmpText + '' + digitOperator;
                                                currentUnknownString = tmp;
                                                // #####
                                                $('#anzeigeCalc span:last').html(getNumber(tmp));

                                        }

                                        break;

                                case 3:
                                        // mehrere ziffern nacheinander eingeben (2. Zahl)
                                        // solange, bis equals angeklickt wurde
                                        // danach sieht man das Ergebnis, das Ergebnis wird Zahl 1 und der Modus ist 4
                                        // gesperrt: Rechenzeichen
                                        if (isDigit) {
                                                if (DEBUG) console.log('case 3, digit');
                                                if (addComma) {
                                                        calcNumber2Str = calcNumber2Str + '.' + digitOperator;
                                                        calcNumber2 = parseFloat(calcNumber2Str);
                                                        //$('#mainInput3').text(replacePointComma(calcNumber2Str));

                                                        var tmp = replacePointComma(digitOperator);
                                                        currentUnknownString += tmp;
                                                        $('#anzeigeCalc span:last').append(getNumber(tmp));

                                                        addComma = false;
                                                }
                                                else {
                                                        calcNumber2Str = calcNumber2Str + '' + digitOperator;
                                                        calcNumber2 = parseFloat(calcNumber2Str);
                                                        //$('#mainInput3').text(replacePointComma(calcNumber2Str));

                                                        var tmp = replacePointComma(digitOperator);
                                                        currentUnknownString += tmp;
                                                        $('#anzeigeCalc span:last').append(getNumber(tmp));

                                                }

                                                // Division durch 0 verhindern:
                                                manageDivisionByZero();

                                                disable(new Array('operators'));

                                        }
                                        else if (digitOperator == ',') {
                                                if (DEBUG) console.log('case 3, comma');
                                                // pruefen, ob das Komma an der ersten Stelle ist
                                                manageComma(false);

                                                disable(new Array('comma'));
                                        }
                                        else if (digitOperator == '=') {
                                                if (DEBUG) console.log('case 3, equals');
                                                calcModus = 4;
                                                $('.operator').removeClass('active');
                                                calcResult = calculate(calcNumber1, calcOperator, calcNumber2);
                                                //$('#mainInput3').text(replacePointComma(calcResult));
                                                calcNumber1 = calcResult;
                                                calcNumber1Str = calcNumber1 + '';

                                                $('#anzeigeCalc span:last').append(getNumber('=' + replacePointComma(calcResult)));

                                                // neue Zeile beginnen
                                                currentUnknownString = "";
                                                if (DEBUG) console.log("SPAN 1 ### case 3, auf = geklickt");
                                                $('#anzeigeCalc').append('<span>');

                                                doNotRestyle = true;

                                                //tmpText = $('#anzeigeCalc').html();
                                                tmpText = currentUnknownString;

                                                addComma = false; // Default-Werte

                                                enable(new Array('operators', 'comma'));
                                                disable(new Array('equals'));

                                        }
                                        else {
                                                if (DEBUG) console.log('case 3, operator');
                                                // Operatoren hier nicht erlaubt
                                        }

                                        break;

                                case 4:
                                        // drück man a) auf eine neue Zahl, ist man im Modus 1
                                        // drück man b) auf ein Rechenzeichen, ist man im Modus 5; zahl 1 ist das letzte Ergebnis
                                        if (isDigit) {
                                                if (DEBUG) console.log('case 4, digit');
                                                calcModus = 1;
                                                calcNumber1 = digitOperator; // erste Ziffer der ersten Zahl
                                                calcNumber1Str = calcNumber1 + '';
                                                //$('#mainInput3').text(calcNumber1Str);

                                                currentUnknownString += calcNumber1Str;
                                                $('#anzeigeCalc span:last').append(getNumber(calcNumber1Str));

                                                //styleResult();

                                                disable(new Array('equals'));
                                        }
                                        else if (digitOperator == ',') {
                                                if (DEBUG) console.log('case 4, comma');
                                                calcModus = 1;

                                                calcNumber1 = '';
                                                calcNumber1Str = '';
                                                manageComma(true);

                                                //styleResult();

                                                disable(new Array('comma', 'equals', 'operators'));
                                        }
                                        else if (digitOperator == '=') {
                                                if (DEBUG) console.log('case 4, equals');
                                                // hier nicht erlaubt
                                        }
                                        else {
                                                if (DEBUG) console.log('case 4, operator');
                                                calcModus = 5;
                                                calcOperator = digitOperator;
                                                $('.operator').removeClass('active');
                                                $(this).addClass('active');

                                                var tmp = replacePointComma(calcResult);
                                                currentUnknownString += tmp;
                                                $('#anzeigeCalc span:last').append(getNumber(tmp));

                                                //tmpText = $('#anzeigeCalc').html();
                                                tmpText = currentUnknownString;

                                                currentUnknownString += digitOperator;
                                                $('#anzeigeCalc span:last').append(getNumber(digitOperator));


                                                //styleResult();

                                        }

                                        break;

                                case 5:
                                        // Erweiterung von Modus 4b: man kann noch das Rechenzeichen aendern
                                        // man bleibt in Modus 5 und kann ein Rechenzeichen waehlen
                                        // solange, bis man eine Zahl gedrueckt hat, ist man im Modus 3
                                        if (isDigit) {
                                                if (DEBUG) console.log('case 5, digit');
                                                calcModus = 3;
                                                calcNumber2 = digitOperator; // erste Ziffer der zweiten Zahl
                                                calcNumber2Str = calcNumber2 + '';

                                                //$('#mainInput3').text(replacePointComma(calcNumber2Str));

                                                var tmp = replacePointComma(calcNumber2Str);
                                                currentUnknownString += tmp;
                                                $('#anzeigeCalc span:last').append(getNumber(tmp));

                                                // Division durch 0 verhindern:
                                                manageDivisionByZero();

                                                disable(new Array('operators'));
                                        }
                                        else if (digitOperator == ',') {
                                                if (DEBUG) console.log('case 5, comma');
                                                calcModus = 3;

                                                calcNumber2 = '';
                                                calcNumber2Str = '';
                                                manageComma(false);

                                                disable(new Array('operators', 'equals', 'comma'));
                                        }
                                        else if (digitOperator == '=') {
                                                if (DEBUG) console.log('case 5, equals');
                                                // hier nicht erlaubt
                                        }
                                        else {
                                                if (DEBUG) console.log('case 5, operator');
                                                calcOperator = digitOperator;
                                                $('.operator').removeClass('active');
                                                $(this).addClass('active');

                                                // #####
                                                var tmp = tmpText + '' + digitOperator;
                                                currentUnknownString = tmp;
                                                $('#anzeigeCalc span:last').html(getNumber(tmp));

                                        }

                                        break;


                        }

                        if (!doNotRestyle) {
                                styleResult();
                        }

                        return false;
                }


                // ENDE "TASCHENRECHNER-MODUS"
                // BEGINN "SPIEL-MODUS":

                if (digitOperator == '=') {
                        if (success) {
                                $('#imgRight').css('display', 'inline-block');
                                resultCounter++;
                                $('#continue').delay(100).fadeIn();
                        }
                        else {
                                $('#imgWrong').css('display', 'inline-block');
                                if (exerciseCounter != 10) {
                                        $('#anzeigeGame2').delay(400).fadeIn();
                                        $('#continue').delay(1000).fadeIn();
                                }
                                else {
                                        $('#continue').delay(100).fadeIn();
                                }
                        }

                        $('#continue').removeClass('newGame weiter');
                        if (exerciseCounter == 10) {
                                $('#continue').addClass('newGame');
                                startNewGame = true;

                                // Lob
                                if (resultCounter == 10) {
                                        $('#lob').css('background-position', '0px 0px');
                                }
                                else if (resultCounter > 6) {
                                        $('#lob').css('background-position', '0px -134px');
                                }
                                else {
                                        $('#lob').css('background-position', '0px -67px');
                                }

                                $('#lob').show();

                        }
                        else {
                                $('#continue').addClass('weiter');
                                startNewGame = false;
                        }

                        exerciseCounter++;

                        addPointClassWithout('p' + resultCounter);
                        $('#punkte').show();

                        disable(new Array('equals', 'numbers', 'operators', 'back'));

                }
                else {

                        // ZAHL oder OPERATOR wurde angeklickt
                        // ->

                        // ersetze das erste Fragezeichen des Eingabefeldes mit dem eingegeben Zeichen

                        var newUnknown = replaceFirstQuestionMark(currentUnknownString, digitOperator);
                        currentUnknownString = newUnknown;
                        $('.unknown').html(getNumber(newUnknown));

                        // prüfen, ob die richtige Loesung eingegeben wurde bzw. ob die Gesamtanzahl der Zeichen erreicht wurde

                        var finish = false;
                        success = false;
                        if (missing == newUnknown || resultIsCorrect(newUnknown)) {
                                // der Anwender hat das richtige Ergebnis eingegeben
                                finish = true;
                                success = true;
                                enable(new Array('equals'));
                                disable(new Array('numbers', 'operators'));
                        }
                        else if (!containsQuestionMark(newUnknown)) {
                                // wenn im Eingabefeld keine Fragezeichen mehr sind, kann Auswertung erfolgen
                                finish = true;
                                success = false;
                                enable(new Array('equals'));
                                disable(new Array('numbers', 'operators'));
                        }
                        else {
                                // die Eingabe ist noch nicht vollstaendig
                                finish = false;
                        }


                        enable(new Array('back'));
                }

        });

        // Listener fuer Reset-Button
        $('#btn_new').click(function() {
                // Reset / New Game
                newGame();

        });


        // Listener fuer C-Button
        $('#clear').click(function() {
                resetCalcVars();
        });

        $('div#language div').click(function() {
                var _this = $(this);
                var _id = _this.attr('id');

                if (_id == 'lang_de') {
                        setLanguage('de');
                }
                else if (_id == 'lang_en') {
                        setLanguage('en');
                }
                else if (_id == 'lang_fr') {
                        setLanguage('fr');
                }
                else if (_id == 'lang_es') {
                        setLanguage('es');
                }

        });


        // Lightbox fuer Impressum
        $(".lightBoxEff").fancybox({
                'width' : 656,
                'height' : 211,
                'autoScale' : false,
                'transitionIn' : 'none',
                'transitionOut' : 'none',
                'type' : 'iframe',
                'overlayOpacity' : 0.6,
                'overlayColor' : '#000',
                'padding' : 0
        });

});

function setLanguage(lang) {
                removeOldLang('en');
                removeOldLang('fr');
                removeOldLang('es');

                var helpText = '';
                if (lang == 'en') {
                        setNewLang('en');
                        helpText = 'Help';
                }
                else if (lang == 'fr') {
                        setNewLang('fr');
                        helpText = 'Aide';
                }
                else if (lang == 'es') {
                        setNewLang('es');
                        helpText = 'Ayuda';
                }
                else if (lang == 'de') {
                        // dynamisch den Hilfe-Link aendern:
                        $('a.helpLink').attr('href', 'pages/help_de.html');
                        helpText = 'Hilfe';
                }

                $('div#help a').text(helpText);
}

function removeOldLang(lang) {
        $('ul#ulStufen li').removeClass(lang);
        $('div#chooseLevel').removeClass(lang);
        $('div#scores').removeClass(lang);
        $('div#aufgabeNo').removeClass(lang);
        $('div#lob').removeClass(lang);
        $('div#continue').removeClass(lang);
        $('div.modus').removeClass(lang);
        $('div.number').removeClass(lang);
        $('div#logo').removeClass(lang);
}

function setNewLang(lang) {
        $('ul#ulStufen li').addClass(lang);
        $('div#chooseLevel').addClass(lang);
        $('div#scores').addClass(lang);
        $('div#aufgabeNo').addClass(lang);
        $('div#lob').addClass(lang);
        $('div#continue').addClass(lang);
        $('div.modus').addClass(lang);
        $('div.number').addClass(lang);
        $('div#logo').addClass(lang);

        // dynamisch den Hilfe-Link aendern:
        $('a.helpLink').attr('href', 'pages/help_' + lang + '.html');

}


function resultIsCorrect(_myUnknown) {
        if (var1 == '') var1 = _myUnknown;
        if (var2 == '') var2 = _myUnknown;
        if (var3 == '') var3 = _myUnknown;
        if (var4 == '') var4 = _myUnknown;

        var2 = var2.replace("×", "*");
        var2 = var2.replace("÷", "/");

        try {
                var _res = eval(var1 + " " + var2 + " " + var3);
                return _res == var4;
        } catch(e) {
        }

        return false;

}

function manageComma(firstNumber) {
        if (DEBUG) console.log("manageComma: firstNumber = " + firstNumber + ", calcNumber1Str = '" + calcNumber1Str + "'");

        if (firstNumber) {
                if (calcNumber1Str == '') {
                        calcNumber1 = '0'; // die erste Ziffer der 1. Zahl
                        calcNumber1Str = '0';
                        if (DEBUG) console.log("SPAN 1 ### managekomma und leerstring ?!?");
                        $('#anzeigeCalc').append('<span>');
                        $('#anzeigeCalc span:last').append(getNumber('0,'));

                }
                else {
                        //$('#mainInput3').text(calcNumber1Str + ',');
                        $('#anzeigeCalc span:last').append(getNumber(','));
                }

                addComma = true;
        }
        else {
                if (calcNumber2Str == '') {
                        calcNumber2 = '0';
                        calcNumber2Str = '0';

                        //$('#mainInput3').text('0,');
                        $('#anzeigeCalc span:last').append(getNumber('0,'));
                }
                else {
                        //$('#mainInput3').text(calcNumber2Str + ',');
                        $('#anzeigeCalc span:last').append(getNumber(','));
                }
                addComma = true;
        }
}

function manageDivisionByZero() {
        if (parseFloat(calcNumber2) == 0 && calcOperator == '÷') {
                disable(new Array('equals'));
        }
        else {
                enable(new Array('equals'));
        }
}


function generateTask() {

        // INIT!!

        //$('.unknown').css('width', null);
        $('.inputElement').removeClass('unknown');
        // Oberflaeche komplett resetten
        $('#continue').hide();
        $('#message').hide();
        $('#info').empty();
        $('#points').hide();
        //disable(new Array('numbers'));

        disable(new Array('all'));
        enable(new Array('new'));


        //$('#exerciseNo').text('Aufgabe ' + exerciseCounter + '/10');
        var newYValue = (10 - exerciseCounter) * AUFGABE_HEIGHT * -1;
        $('#aufgabeNo').css('background-position', '0px ' + newYValue + 'px');


        var result;
        var operatorStr;

        // zufaellig Operator ermitteln: plus, minus, mal, durch
        var operator = generateRandomOperator();
        var firstNum;
        var secondNum;
        if (level == 1 || level == 3) {
                // generiere zwei einstellige Zahlen
                firstNum = generateRandomDigit();
                secondNum = generateRandomDigit();
        }
        else if (level == 2) {
                if (randomBoolean()) {
                        // generiere zwei zweistellige Zahlen
                        firstNum = generateRandomNumber();
                        secondNum = generateRandomNumber();
                }
                else {
                        // generiere eine einstellige und eine zeistellige Zahl
                        firstNum = generateRandomDigit();
                        secondNum = generateRandomNumber();
                }
        }
        else if (level == 4) {
                if (operator == 1 || operator == 2) {
                        // wenn Addition oder Subtraktion
                        // generiere zwei zweistellige Zahlen
                        firstNum = generateRandomNumber();
                        secondNum = generateRandomNumber();
                }
                else {
                        // wenn Multiplikation oder Division
                        // generiere eine einstellige und eine zeistellige Zahl
                        firstNum = generateRandomDigit();
                        secondNum = generateRandomNumber();
                }
        }

        /*
        else {
                if (randomBoolean() && level == 2) {
                        // generiere zwei zweistellige Zahlen
                        firstNum = generateRandomNumber();
                        secondNum = generateRandomNumber();
                }
                else {
                        // generiere eine einstellige und eine zeistellige Zahl
                        firstNum = generateRandomDigit();
                        secondNum = generateRandomNumber();
                }
        }
        */

        // wenn Operator "/": erstelle Aufgabe mit Hilfe Multiplikation, deren Ergebnis kleiner 100 ist
        if (operator == 4) {
                var aNum = firstNum;
                var bNum = secondNum;

                // Ergebnis berechnen
                var cNum = aNum * bNum;

                // Variablen zufaellig tauschen, da 2 Möglickeiten
                // 1.: c / a = b
                // 2.: c / b = c
                if  (randomBoolean()) {
                        firstNum = cNum;
                        secondNum = aNum;
                        result = bNum;
                }
                else {
                        firstNum = cNum;
                        secondNum = bNum;
                        result = aNum;
                }

                operatorStr = '÷';

        }


        // wenn Operator "-": erste Zahl muss groesser zweite Zahl sein
        if (operator == 2) {
                if (secondNum > firstNum) {
                        var tmp = firstNum;
                        firstNum = secondNum;
                        secondNum = tmp;
                }
        }

        // wenn Operator "*": mindestens eine Zahl muss einstellig sein
        if (operator == 3) {
                if (firstNum > 9 && secondNum > 9) {
                        if (randomBoolean()) {
                                firstNum = generateRandomDigit();
                        }
                        else {
                                secondNum = generateRandomDigit();
                        }
                }

        }

        // 2. Ergebnis berechnen:
        switch (operator) {
                case 1: result = firstNum + secondNum; operatorStr = '+'; break;
                case 2: result = firstNum - secondNum; operatorStr = '-'; break;
                case 3: result = firstNum * secondNum; operatorStr = '×'; break;
                //der Divisionsfall 4 wurde oben schon behandelt
        }

        // TODO: Loeschen! Anzeigen der Loesung:
        $('#info').append(firstNum + ' ' + operatorStr + ' ' + secondNum + ' = ' + result);

        /* 3. entscheiden, welcher Modus gespielt wird:
                a) das erste Zeichen fehlt
                b) der Operator fehlt
                c) das zweite Zeichen fehlt
                d) das Ergebnis fehlt
        */
        modus = generateRandomModus();

        switch (modus) {
                case 1:
                        missing = firstNum;
                        fill('', operatorStr, secondNum, result);
                        $('#firstNum').addClass('unknown');
                        enable(new Array('numbers'));
                        enableOperators = false;
                        break;
                case 2:
                        missing = operatorStr;
                        fill(firstNum, '', secondNum, result);
                        $('#operator').addClass('unknown');
                        enable(new Array('operators'));
                        enableOperators = true;
                        break;
                case 3:
                        missing = secondNum;
                        fill(firstNum, operatorStr, '', result);
                        $('#secondNum').addClass('unknown');
                        enable(new Array('numbers'));
                        enableOperators = false;
                        break;
                case 4:
                        missing = result;
                        fill(firstNum, operatorStr, secondNum, '');
                        $('#result').addClass('unknown');
                        enable(new Array('numbers'));
                        enableOperators = false;
                        break;
        }

        fill2(firstNum, operatorStr, secondNum, result);

        // Groesse des Eingabefeld anpassen und passende Anzahl Fragezeichen reinschreiben
        var stellen = anzahlStellen(missing);
        //$('.unknown').css('width', stellen * 12);
        currentUnknownString = getQuestionMarks(stellen);
        $('.unknown').html(getNumber(currentUnknownString));


}

var var1;
var var2;
var var3;
var var4;


var enableOperators = false;
function calculate(firstNum, operator, secondNum) {
        var res = 0;
        switch (operator) {
                case '+': res = parseFloat(firstNum) + parseFloat(secondNum); break;
                case '-': res = parseFloat(firstNum) - parseFloat(secondNum); break;
                case '×': res = parseFloat(firstNum) * parseFloat(secondNum); break;
                case '÷': res = parseFloat(firstNum) / parseFloat(secondNum); break;
        }
        return kaufm(res);
}

function kaufm(x) {
        var xStr = x.toString();

        // 1. pruefen, ob die Zahl eine Gleitpunktzahl ist
        var indexPoint = xStr.indexOf('.');
        if (indexPoint == -1) {
                return xStr;
        }

        // 2. pruefen, ob die Zahl mehr als vier Nachkommastellen hat
        if (xStr.length - indexPoint < 6) {
                return xStr;
        }

        // 3. auf vier Nachkommastellen runden
        return (Math.round(x * 10000) / 10000).toString();
}

function replacePointComma(k) {
        // 4. ersetze "." durch ","
        if (!k || k == '')
                return k;

        k = k.toString();
        var indexPoint = k.indexOf('.');
        if (indexPoint != -1) {
                return k.substring(0, indexPoint) + ',' + k.substring(indexPoint+1);
        }
        else {
                return k;
        }
}

function fill(firstNum, operator, secondNum, result) {
        $('#firstNum').html(getNumber(firstNum));
        $('#operator').html(getNumber(operator));
        $('#secondNum').html(getNumber(secondNum));
        $('#result').html(getNumber(result));
        var1 = firstNum;
        var2 = operator;
        var3 = secondNum;
        var4 = result;
}

function fill2(firstNum, operator, secondNum, result) {
        $('#firstNum2').html(getNumber(firstNum));
        $('#operator2').html(getNumber(operator));
        $('#secondNum2').html(getNumber(secondNum));
        $('#result2').html(getNumber(result));
}

function getNumber(number) {
        var ret = '';
        var numStr = number.toString();
        for (var i=0; i<numStr.length; i++) {
                var character = numStr[i];
                if (!isNaN(parseInt(numStr[i], 10))) {
                        // Ziffer
                        ret += '<div class="zahl zahl_' + character + '"></div>';
                }
                else {
                        // anderes Zeichen
                        switch (character) {
                                case '+': ret += '<div class="zahl zahl_plus' + (calculatorMode ? " addMargin" : "") + '"></div>'; break;
                                case '-': ret += '<div class="zahl zahl_minus' + (calculatorMode ? " addMargin" : "") + '"></div>'; break;
                                case '×': ret += '<div class="zahl zahl_mul' + (calculatorMode ? " addMargin" : "") + '"></div>'; break;
                                case '÷': ret += '<div class="zahl zahl_div' + (calculatorMode ? " addMargin" : "") + '"></div>'; break;
                                case '=': ret += '<div class="zahl zahl_gleich addMargin"></div>'; break;
                                case '?': ret += '<div class="zahl zahl_frage"></div>'; break;
                                case ',': ret += '<div class="zahl zahl_komma"></div>'; break;
                                default:  ret += '<div class="zahl2">' + character + '</div>';
                        }
                }
        }

        return ret;

}


// Variablen des Taschenrechners resetten
function resetCalcVars() {
        calcNumber1 = '';
        calcNumber2 = '';
        calcNumber1Str = '';
        calcNumber2Str = '';
        calcOperator = '';
        calcResult = 0;
        addComma = false;
        calcModus = 1;
        tmpText = '';

        disable(new Array('operators', 'equals', 'steps', 'new'));
        enable(new Array('numbers', 'comma', 'clear'));
        $('#anzeigeCalc').empty();

}

function newGame() {
        startNewGame = false;
        resultCounter = 0;
        exerciseCounter = 1;
        success = false;

        level = 0;
        calculatorMode = false;

        $('#continue').hide();
        $('#continue').removeClass('newGame weiter');
        $('#chooseLevel').show();
        $('#aufgabeNo').hide();
        $('#aufgabeNo').css('background-position', null);
        $('#continue').hide();
        $('#lob').hide();
        addPointClassWithout('');

        resetSteps();
        $('#divStufen').fadeIn();

        $('#anzeigeCalc').hide();
        $('#anzeigeGame').hide();
        $('#anzeigeGame2').hide();
        $('.modus').removeClass('isHover');
        $('#modus_1').css('background-position', '0 0');
        $('#modus_2').css('background-position', '-368px -45px');

        $('#imgRight').hide();
        $('#imgWrong').hide();


        disable(new Array('all'));
        enable(new Array('steps'));

}

/*
 * Gibt die Anzahl der Stellen zurueck.
 */
function anzahlStellen(number) {
        return (number + '').length;
}

/*
 * Generiert <number> Blank-Zeichen hintereinander und
 * gibt sie als String zurueck.
 */
function getQuestionMarks(number) {
        var ret = '';
        for (var i=0; i<number; i++) {
                ret += '?';
        }
        return ret;
}

/*
 * Ersetzt das erste Blank-Zeichen eines Strings
 * durch eine Zahl.
 */
function replaceFirstQuestionMark(str, digit) {
        for (var i=0; i<str.length; i++) {
                if (str.charAt(i) == '?') {
                        var strA = str.substring(0, i);
                        var strB = str.substring(i + 1);
                        return strA + digit + strB;
                }
        }
        return str;
}

/*
 * Loescht die letzte Ziffern bzw. das letzte Rechenzeichen eines Strings.
 */
function deleteFirstDigitOrOperator(str) {
        for (var i=0; i<str.length; i++) {
                if (str.charAt(i) == '?') {
                        // Zeichen bei (i-1) durch '?' ersetzen
                        if (i == 0) {
                                return str;
                        }

                        var strA = str.substring(0, i-1);
                        var strB = str.substring(i);
                        return strA + '?' + strB;
                }
        }

        // wenn in der Schleife nichts ersetz wurde, enthaelt der String kein '?'
        // dann muss das letzte Zeichen durch '?' ersetzt werden
        var strLen = str.length;
        if (!strLen || strLen == 0) {
                return '';
        }
        else if (strLen == 1) {
                return '?';
        }
        else {
                var strA = str.substring(0, strLen-1) + '?';
                return strA;
        }


}

/*
 * Prueft, ob in einem String ein Blank-Zeichen enthalten ist.
 */
function containsQuestionMark(str) {
        for (var i=0; i<str.length; i++) {
                if (str.charAt(i) == '?') {
                        return true;
                }
        }
        return false;
}

/*
 * Prueft, ob in einem String eine Zahl oder ein Rechenzeichen enthalten ist.
 */
function containsInput(str) {
        for (var i=0; i<str.length; i++) {
                if (str.charAt(i) != '?') {
                        return true;
                }
        }
        return false;
}


function generateRandomNumber() {
        return generateRandomTwoDigit(99);
}

function generateRandomDigit() {
        return generateRandom(9);
}

function generateRandomOperator() {
        if (level == 1 || level == 2) {
                // nur Addition oder Subtraktion
                return generateRandom(2);
        }
        else if (level == 3) {
                // nur Multiplikation und Division
                return generateRandom(2) + 2;
        }
        else {
                // alle 4 Grundrechenarten
                return generateRandom(4);
        }
}

function generateRandomModus() {
        return generateRandom(4);
}

function randomBoolean() {
        return (generateRandom(2) == 1);
}

function random80PerCent() {
        return (generateRandom(10) > 2);
}

function generateRandom(max) {
        return Math.ceil(Math.random() * max); //liefert Zahlen von 1 bis max
}

function generateRandomTwoDigit(max) {
        return Math.round(Math.random()*(max-10)) + 10; //liefert Zahlen von 10 bis max
}

function disable(e) {
        for (var i=0; i<e.length; i++) {
                showHide(e[i], false);
        }
}

function enable(e) {
        for (var i=0; i<e.length; i++) {
                showHide(e[i], true);
        }
}


function showHide(e, show) {
        switch (e) {
                case 'all':
                        if (show)
                                $('.number').activate();
                        else
                                $('.number').deactivate();
                        break;
                case 'numbers':
                        if (show)
                                $('.digit').activate();
                        else
                                $('.digit').deactivate();
                        break;
                case 'operators':
                        if (show)
                                $('.operator').activate();
                        else
                                $('.operator').deactivate();
                        break;
                case 'comma':
                        if (show)
                                $('#btn_comma').activate();
                        else
                                $('#btn_comma').deactivate();
                        break;
                case 'equals':
                        if (show)
                                $('#btn_equals').activate();
                        else
                                $('#btn_equals').deactivate();
                        break;
                case 'steps':
                        if (show)
                                $('#ulLevel li span').activate();
                        else
                                $('#ulLevel li span').deactivate();
                        break;
                case 'back':
                        if (show)
                                $('#back').activate();
                        else
                                $('#back').deactivate();
                        break;
                case 'new':
                        if (show)
                                $('#btn_new').activate();
                        else
                                $('#btn_new').deactivate();
                        break;
                case 'clear':
                        if (show)
                                $('#clear').activate();
                        else
                                $('#clear').deactivate();
                        break;

        }
}


function getSpanSize(span) {
        if (span.hasClass('size2')) {
                return 2;
        }
        if (span.hasClass('size3')) {
                return 3;
        }
        if (span.hasClass('size4')) {
                return 4;
        }
        return 1;
}

function removeClassesWithout(span, current) {
        if (current != 'size2') {
                span.removeClass('size2');
        }
        if (current != 'size3') {
                span.removeClass('size3');
        }
        if (current != 'size4') {
                span.removeClass('size4');
        }
}

function addPointClassWithout(classToAdd) {
        var classesToRemove = '';
        for (var i=1; i<11; i++) {
                var tmp = 'p' + i;
                if (tmp != classToAdd) {
                        classesToRemove += ' ' + tmp;
                }
        }

        $('#punkte').removeClass(classesToRemove);
        $('#punkte').addClass(classToAdd);

}


function styleResult() {
        var _span = $('#anzeigeCalc span');
        var countSpan = _span.length;

        _span.each(function(index) {
                var _this = $(this);
                var currentSize = getSpanSize(_this);

                var summe = 0;
                _this.find('div').each(function() {
                        var myDiv = $(this);
                        summe += myDiv.outerWidth() + parseInt(myDiv.css('margin-left')) + parseInt(myDiv.css('margin-right'));
                });

                if (summe > 632 && currentSize < 4) {
                        currentSize++;
                }
                if (summe > 756 && currentSize < 4) {
                        currentSize++;
                }
                if (summe > 936 && currentSize < 4) {
                        currentSize++;
                }

                var diff = countSpan - index;
                if (diff < currentSize) {
                        diff = currentSize;
                }

                if (diff > 4) {
                        _this.hide();
                }
                else {
                        switch (diff) {
                                case 4:
                                        _this.addClass('size4');
                                        removeClassesWithout(_this, 'size4');
                                        break;
                                case 3:
                                        _this.addClass('size3');
                                        removeClassesWithout(_this, 'size3');
                                        break;
                                case 2:
                                        _this.addClass('size2');
                                        removeClassesWithout(_this, 'size2');
                                        break;
                                case 1:
                                        removeClassesWithout(_this, '');
                                        break;
                        }
                }

        });
}

var showAlert = true;
function hover(element, width, isOnMouseOver) {
        var posX;
        var posY;
        if (element.css('background-position-x')) {
                posX = parseInt(element.css('background-position-x'));
                posY = parseInt(element.css('background-position-y'));
        } else {
                var posBoth = element.css('background-position');
                posX = parseInt(posBoth.split(' ')[0]);
                posY = parseInt(posBoth.split(' ')[1]);
        };

        if (isOnMouseOver) {
                posX -= width;
        }
        else {
                posX += width;
        }

        element.css('background-position', posX + 'px ' + posY + 'px');

}

function hideOtherLevel(level) {
        for (var i=1; i<5; i++) {
                if (i != level) {
                        $('#stufe_' + i).animate({opacity:0.15});
                }
        }

}

function resetSteps() {
        // Stufen resetten:
        $('.stufe').css('opacity', 1);
        $('.stufe').removeClass('inactive isHover');
        $('.stufe').each(function() {
                $(this).css('background-position', null);
        });
}




