﻿

var CONST_TYPE_AUFG_LOES = "aufgaben";
var DATA_FOLDER = "../data";
var DOCUMENT_FOLDER = "../..";
var IMAGES_FOLDER = "../images/";
var CONST_EXT = ".csv";


var trIndex = 1;


function h_readFile(fileUrl) {
	var req;
	var fileContent;
	
	if (window.ActiveXObject) {
		// IE/Windows ActiveX
		req = new ActiveXObject("Microsoft.XMLHTTP");
		req.open("GET", fileUrl, false);
		req.onreadystatechange=function() {
									if (req.readyState == 4) {
										fileContent = req.responseText;
									}
								};
		req.send(null);
	} 
	else if (window.XMLHttpRequest) {
		// native XMLHttpRequest object
		req = new XMLHttpRequest();
		req.open("GET", fileUrl, false);
		req.send(null);
		fileContent = req.responseText;
	}  
	
	return fileContent;
	
}


function h_addRow(elements, contentType, myRows) {
	var trBlock = '<tr class="tr' + trIndex + '">';

	trBlock += '<td style="width: 400px; padding-left: 6px;">';
	trBlock += elements[0];
	trBlock += '&nbsp;</td>';

	trBlock += '<td align="center" style="width: 44px">';
	if (elements[1] && elements[1] != "") {
		trBlock += '<a target="_blank" href="' + DOCUMENT_FOLDER + '/' + contentType + '/' + elements[1] + '"><img border="0" src="' + h_getIconPath(elements[2]) + '" title="Datei auswählen!"></a>';
	}
	else {
		trBlock += '&nbsp;';
	}
	trBlock += '</td>';

	trBlock += '<td align="center" style="width: 44px">';
	if (elements[3] && elements[3] != "") {
		trBlock += '<a target="_blank" href="' + DOCUMENT_FOLDER + '/' + contentType + '/' + elements[3] + '"><img border="0" src="' + h_getIconPath(elements[4]) + '" title="Datei auswählen!"></a>';
	}
	else {
		trBlock += '&nbsp;';
	}
	trBlock += '</td>';
		
	trBlock += '<td align="center">';
	if (elements[5] && elements[5]!= "") {
		trBlock += '<a target="_blank" href="' + DOCUMENT_FOLDER + '/' + contentType + '/' + elements[5] + '"><img border="0" src="' + h_getIconPath(elements[6]) + '" title="Datei auswählen!"></a>';
	}
	else {
		trBlock += '&nbsp;';
	}
	trBlock += '</td>';

	trBlock += '</tr>';
	
	
	
	trIndex = (trIndex == 1 ? trIndex - 1 : trIndex + 1);
	
	myRows += trBlock;
	
	return myRows;
	
}


function h_getIconPath(iconName) {
	switch (iconName) {
		case "pdf":   return IMAGES_FOLDER + "icon-pdf.gif";
		case "pdf-l": return IMAGES_FOLDER + "icon-pdf-l.gif";
		case "doc":   return IMAGES_FOLDER + "icon-doc.gif";
		case "ppt":   return IMAGES_FOLDER + "icon-ppt.gif";
		case "doc":   return IMAGES_FOLDER + "icon-doc.gif";
		default:      return IMAGES_FOLDER + "icon-default.gif";
	}

}


function h_fillATab(fileName, contentType, elementId) {
	var contentOfFile = "";
	try {
		contentOfFile = h_readFile(fileName);
		
		var lines = contentOfFile.split("\r\n");

		var head1 = "";
		var head2 = "";
		var head3 = "";
		
		// HIER die Ueberschriften in den Tabellen anpassen:
		switch (contentType) {
			case "aufgaben":
				head1 = "Aufgabe";
				head2 = "L&ouml;sung";
				head3 = "Word";
				break;
				
			case "skripte":
				head1 = "Skript";
				head2 = "L&ouml;sung";
				head3 = " ";
				break;
		
			case "lernspiele":
				head1 = "PDF Spiel";
				head2 = "Powerpoint";
				head3 = " ";
				break;
				
			case "kreuzwortraetsel":
				head1 = "R&auml;tsel";
				head2 = " ";
				head3 = " ";
				break;
				
			case "kopfrechnen":
				head1 = "Blatt";
				head2 = " ";
				head3 = " ";
				break;
				
			case "leseproben":
				head1 = "Leseprobe";
				head2 = " ";
				head3 = " ";
				break;
		}
		
		// Kopf der Tabelle schreiben: Aufgabe, Lösungen
		$("#"+elementId).html('<tr><td></td><td class="tdSmall">' + head1 + '</td><td class="tdSmall">' + head2 + '</td><td class="tdSmall">' + head3 + '</td></tr>');
		
		trIndex = 1;
		
		var allRows = "";
		
		for (var i=1; i<lines.length; i++) {
			var line = lines[i];
			var elements = line.split(";");
			if (elements && elements.length >= 2) {
				allRows = h_addRow(elements, contentType, allRows);
			}
		}
		
		$("#"+elementId).append(allRows);

	} catch (ex) {
		$("#"+elementId).html("<b>Datei '" + fileName + "' nicht gefunden!</b><br><br>Error: " + ex);
	}
	
}


function h_fillTabs(contentType) {
	var fileName = DATA_FOLDER + '/' + contentType;
	if (contentType == CONST_TYPE_AUFG_LOES) {
		for (var k=5; k<=10; k++) {
			var fileName2 = fileName;
			fileName2 += k + CONST_EXT;
			h_fillATab(fileName2, contentType, 'class' + k);
		}
	}
	else {
		h_fillATab(fileName + CONST_EXT, contentType, 'tabDefault');
	}

}


function h_startCD(contentType) {
	h_fillTabs(contentType);
	
}






